using System;
using Server;
using Server.Items;
using System.Collections;

namespace Server.Mobiles
{
    public class GuardianAngel : BaseCreature
    {
        public override bool IsDispellable { get { return false; } }
        public override bool DeleteCorpseOnDeath { get { return true; } }

        [Constructable]
        public GuardianAngel() : base(AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4)
        {
            Name = "guardian angel";
            Body = 123;
            Hue = 2628;

            SetStr(90);
            SetDex(110);
            SetInt(150);

            SetHits(900, 999);
            SetStam(191, 200);

            SetDamage(1, 2);

            SetDamageType(ResistanceType.Physical, 30);
            SetDamageType(ResistanceType.Energy, 70);

            SetResistance(ResistanceType.Physical, 99);
            SetResistance(ResistanceType.Fire, 99);
            SetResistance(ResistanceType.Cold, 99);
            SetResistance(ResistanceType.Poison, 99);
            SetResistance(ResistanceType.Energy, 99);

            SetSkill(SkillName.EvalInt, 100.1, 120.0);
            SetSkill(SkillName.Meditation, 90.1, 100.0);
            SetSkill(SkillName.Magery, 100.1, 120.0);
            SetSkill(SkillName.MagicResist, 100.1, 120.0);
            SetSkill(SkillName.Tactics, 120.0);
            SetSkill(SkillName.Wrestling, 100.1, 120.0);
            SetSkill(SkillName.Poisoning, 90.1, 100.0);

            VirtualArmor = 58;
            ControlSlots = 1;
        }

        public override bool OnBeforeDeath()
        {
            Effects.SendLocationEffect(Location, Map, 0x376A, 10, 1);
            Hits = HitsMax;
            return false;
        }

        public override void OnDelete()
        {
            if (SummonMaster != null)
                m_Table.Remove(SummonMaster);

            base.OnDelete();
        }

        public override Poison PoisonImmune { get { return Poison.Lethal; } } // TODO: Immune to poison?
        public override bool BleedImmune { get { return true; } }

        private static Hashtable m_Table = new Hashtable();

        public static bool HasAngel(Mobile m)
        {
            return m_Table.Contains(m);
        }

        public static void AddAngel(Mobile m, BaseCreature angel)
        {
            m_Table[m] = angel;
        }

        public static BaseCreature GetAngel(Mobile m)
        {
            return (m_Table.Contains(m)) ? (BaseCreature)m_Table[m] : null;
        }

        public override int GetAngerSound()
        {
            return 0x2F8;
        }

        public override int GetIdleSound()
        {
            return 0x2F8;
        }

        public override int GetAttackSound()
        {
            return Utility.Random(0x2F5, 2);
        }

        public override int GetHurtSound()
        {
            return 0x2F9;
        }

        public override int GetDeathSound()
        {
            return 0x2F7;
        }

        public GuardianAngel(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();

            if (SummonMaster != null)
                m_Table[SummonMaster] = this;
        }
    }
}